///////////////////////////////////////////////////////////////////////////////////////////

#define WM_SHELLNOTIFY WM_USER+5

UINT TB_CREATED = -1;

#define ID_ViewSched 1002
#define ID_Manager   1003
#define ID_Exit      1004

NOTIFYICONDATA Note; // Tray Icon Structure

POINT pt;            // Pointer (Used For Tray Icon Popup Menu)

HMENU MainMenu;      //Tray Icon Popup Menu
HMENU FileMenu;      //Tray Icon Popup Menu

HWND TrayIcon_hWnd = NULL;

LRESULT CALLBACK TrayIconProc(HWND, UINT, WPARAM, LPARAM);
BOOL FindFirstInstance(char *);
BOOL LoadTrayIcon(int, char *);
void UpdateTrayIcon(int, char *);
BOOL DestroyTrayIcon(void);

///////////////////////////////////////////////////////////////////////////////////////////

BOOL FindFirstInstance(char *AppName)
{
    HWND xHandle = NULL;
    xHandle = FindWindow(AppName, NULL);
    if(xHandle) return TRUE;
    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////

BOOL LoadTrayIcon(int Icon, char *Title)
{
    WNDCLASS Wc;
    MSG Msg;

    if( FindFirstInstance(TitleCaption) )
    {
        return FALSE;
    }

    Wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
    Wc.lpfnWndProc   = TrayIconProc;
    Wc.cbClsExtra    = 0;
    Wc.cbWndExtra    = 0;
    Wc.hInstance     = MainInstance;
    Wc.hIcon         = LoadIcon(NULL, IDI_WINLOGO);
    Wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    Wc.hbrBackground = GetSysColorBrush(COLOR_BTNFACE);
    Wc.lpszMenuName  = NULL;
    Wc.lpszClassName = TitleCaption;

    RegisterClass(&Wc);

    HWND MainFORM = CreateWindow(TitleCaption,Title,WS_POPUP|WS_SYSMENU,0,0,0,0,NULL,(HMENU)NULL,MainInstance,NULL);

    Note.cbSize           = sizeof(NOTIFYICONDATA);
    Note.hWnd             = MainFORM;
    Note.hIcon            = LoadIcon(MainInstance, MAKEINTRESOURCE(Icon) );
    Note.uFlags           = NIF_ICON | NIF_TIP | NIF_MESSAGE;
    Note.uCallbackMessage = WM_SHELLNOTIFY;

    if(Title) strcpy(Note.szTip, Title);

    Shell_NotifyIcon(NIM_ADD, &Note);

    MainMenu = CreateMenu();
    FileMenu = CreateMenu();

    AppendMenu(FileMenu, MF_STRING, ID_Manager, "Job &Manager");
    AppendMenu(FileMenu, MF_SEPARATOR, 0, "MF_SEPARATOR");
    AppendMenu(FileMenu, MF_STRING, ID_ViewSched, "View &Schedule");

    if(RunningAsService == FALSE)
    {
        AppendMenu(FileMenu, MF_SEPARATOR, 0, "MF_SEPARATOR");
        AppendMenu(FileMenu, MF_STRING, ID_Exit, "E&xit");
    }

    InsertMenu(MainMenu, 0, MF_POPUP, (UINT)FileMenu, "invisible menu");
    while( GetMessage(&Msg, NULL, 0, 0) )
    {
        if( !IsWindow(MainFORM) || !IsDialogMessage(MainFORM, &Msg) )
        {
            TranslateMessage(&Msg);
            DispatchMessage(&Msg);
        }
    }

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////

void UpdateTrayIcon(int Icon, char *Title)
{
    if(Icon != -1) Note.hIcon = LoadIcon(MainInstance, MAKEINTRESOURCE(Icon) );
    if(Title) strcpy(Note.szTip, Title);
    Shell_NotifyIcon(NIM_MODIFY, &Note);
}

///////////////////////////////////////////////////////////////////////////////////////////

BOOL DestroyTrayIcon(void)
{
    return Shell_NotifyIcon(NIM_DELETE, &Note); // Remove Tray Icon
}

///////////////////////////////////////////////////////////////////////////////////////////

